/*
 * comment macro definition + removal is a temporary fix for the
 * comment declaration in (pwd.h> brought in by <libc.h>
 * under SunOS 4.1 - if not present, cfront(2.0) barfs.
 */
#define comment ___comment
#include "core.h"
#undef comment
#include "process.h"
#include "master.h"
#include "sigmask.h"
#include "frame.h"
#include "memory.h"
#include "symtab.h"
#include "symbol.h"
#include "srcdir.h"
#include "asm.h"
#include "bpts.h"
#include "expr.h"
#include "host.h"
SRCFILE("host.c")

extern "C" {
	int	pi_atsyscall(void*);
	void	pi_close(void*);
	void	*pi_coreopen(char*,char*);
	char	*pi_csig(void*);
	char	*pi_destroy(void*);
	char	*pi_exechang(void*,long);
	int	pi_exechangsupported();
	int	pi_getppid(void*);
	char	**pi_getpscmds();
	int	pi_getpsfield();
	void	pi_getstate(void*, Unixstate*);
	int	pi_getsymtabfd(void*);
	int	pi_hang(char*);
	int	pi_nsig();
	void	*pi_open(int);
	int	pi_stabfdsupported();
	void	*pi_pidtoproc(int);
	char	*pi_proctime(void*);
	char	*pi_osname();
	char	*pi_readwrite(void*,char*,long,int,int);
	long	pi_regaddr();
	char	*pi_run(void*);
	long	pi_scratchaddr();
	char	*pi_setbkpt(void*,long);
	char	*pi_sigmask(void*,long);
	long	pi_sigmaskinit();
	char	*pi_signalname(long);
	char	*pi_ssig(void*,long);
	char	*pi_step(void*);
	char	*pi_stop(void*);
	char	*pi_waitstop(void*);
}

#define	K	DB_KERNELID

extern char *PATH;

HostMaster::HostMaster()	{ open(); }

Process	*HostMaster::newProcess(Process *pr, char *p, char *s, char* c)
{
	return new HostProcess(pr, p, s, c);
}

void HostMaster::open()
{
	Menu m, q, h;

	pad = new Pad( (PadRcv*) this );
	pad->options(TRUNCATE|SORTED|ACCEPT_KBD);
	pad->name( "Pi");
	pad->banner("Pi - %s: Copyright 1986-1993 AT&T", pi_osname());
	pscmds = pi_getpscmds();
	for(long i = 1; pscmds[i-1]; i++ )
		m.last( pscmds[i-1], (Action)&HostMaster::refresh, i );
	h.last("help", (Action)&HostMaster::openhelp);
	m.last(h.index("help"));
	q.last("quit?", (Action)&HostMaster::exit, 0);
	m.last(q.index("quit"));
	pad->menu(m.index("ps"));
	pad->makecurrent();
	refresh(0);
}

void HostMaster::openhelp()
{
	extern int helptopic(char*);
	helptopic("Introduction");
}

void HostMaster::exit() { PadsQuit(); }

#define PSOUT 100
#define PROCS 100
char *HostMaster::dopscmd(int cmd)
{
	char psout[PROCS][PSOUT];
	FILE *f, *Popen(char*,char*);
	int Pclose(FILE *);
	int pid, i, j, e;
	char *err = 0;
	SIG_TYP save;

	if (!cmd) return 0;
	cmd--;
	if (!pscmds[cmd]) return 0;

	save = signal(SIGCLD, SIG_DFL);
	if (!(f = Popen(pscmds[cmd], "r"))) {
		err = SysErr( "cannot read from popen(): ");
		goto out;
	} 
	for (i = 0; i < PROCS && fgets(psout[i],PSOUT,f); i++){}
	if (e = Pclose(f)) {
		err = sf( "exit(%d): %s", e, pscmds[cmd] );
		goto out;
	}
	for (j = 0; j <= i; ++j)
		if (2 == sscanf(psout[j], " %d %[^\n]", &pid, psout[0]))
			makeproc(sf("%05d",pid), 0, psout[0]);
out:
	signal(SIGCLD, save);
	return err;
}

void HostMaster::refresh(int cmd)
{
	char *error;
	Process *p;

	pad->clear();
	makeproc( "core", "a.out", "" );
	makeproc( "!", "a.out", "" );
	if( error = dopscmd(cmd) ) pad->error(error);
	for( p = child; p; p = p->sibling )
		if( p->core || (p->procpath && eqstr(p->procpath,"!")))
			insert(p);
}

char *HostMaster::kbd(char *s)
{
	char *corep, core[64], syms[64], star = 0;
	HostProcess *p;
	static char helpstring[] = "Incorrect input: type ? for help";

	while( *s == ' ' ) ++s;
	switch( *s ){
	case '!':
		for( ++s; *s==' '; ++s ) {}
		makeproc("!", s, "");
		break;
	case '*':
		star = 1;
		for( ++s; *s==' '; ++s ) {}
	default:
		switch( sscanf(s, "%s %s \n", corep = core, syms) ){
		case 1:	if (!pi_stabfdsupported() || !alldigits(corep))
				return helpstring;
			syms[0] = '\0';
		case 2:	if( alldigits(corep) ) {
				int id;
				sscanf(corep, "%d", &id);
				corep = sf("%05d", id);
			}
			p = (HostProcess*) makeproc(corep, syms[0]?syms:0, 0);
			if( star && p ) p->open(0);
			break;
		default:
			return helpstring;
		}
	}
	return 0;
}

char *HostMaster::help(long l)
{
	switch(l) {
		case HELP_OVERVIEW:	return "Unix Pi Window";
		case HELP_MENU:		return "Unix Pi Menu Bar";
		case HELP_KEY:		return "Unix Pi Keyboard";
		case HELP_LMENU:	return "Unix Pi Line Menus";
		default:		return 0;
	}
}

HostProcess::HostProcess(Process *sib, char *p, char *s, char *c)
 : Process(sib,p,s,c) {}

void HostProcess::batch()
{
	core = newCore(master);
	char *error = core->open();
	if( error ){
		fprintf(stderr, "%s\n", error);
		exit(1);
	}
	CallStk *c = core->callstack();
	if (!c) {
		printf("Cannot obtain callstack\n");
		long pc = core->pc();
		if (pc) {
			char *s = symtab()->symaddr(pc);
			if (*s)
				printf("pc=%s\n", s);
			else
				printf("pc=0x%X\n", pc);
		} else
			printf("Cannot obtain pc\n");
		return;
	}
	for( long l = c->size-1; l>=0; --l )
		if( l<32 || l>c->size-32 ){
		Frame f = c->frame(l);
		Bls t;
		f.addsymbols();
		printf("%s\n", f.text(t));
		if( f.func ){
			BlkVars bv(f.func->blk(f.pc));
			Var *v;
			while( v = bv.gen() ){
				Bls tt;
				if( v->disc() == U_ARG ) continue;
				Expr *e = E_Sym(v);
				e->evaltext(&f, tt);
				printf("\t%s\n", tt.text);
			}
		}
	}
}

void HostProcess::takeover()
{
	if (pad) {
		open(0);
		insert(ERRORKEY, "take over: already open");
		return;
	}
	if (fixsymtab())
		return;
	Pick("take over", (Action)&HostProcess::substitute, (long)this);
}

int HostProcess::fixsymtab()
{
	char *nstab;
	char file[80];

	if (stabpath || pi_stabfdsupported())
		return 0;
	sscanf(&comment[pi_getpsfield()], "%s", file);
	if ((nstab = pathexpand(file, PATH, 5)) == 0) {
		insert(ERRORKEY, "Can't find symbol table file");
		return 1;
	}
	stabpath = sf("%s", nstab);
	comment = 0;
	master->insert(this);
	return 0;
}

int HostProcess::accept( Action a )
{
	return a == (Action)&HostProcess::substitute;
}

void HostProcess::substitute(HostProcess *t)
{
	char *error, *oldprocpath, *oldstabpath, *oldcomment;

	insert(ERRORKEY, 0);
	if( !core ){
		insert(ERRORKEY, "that ought to work - but it doesn't");
		return;
	}
	if( !core->online() ){
		insert(ERRORKEY, "cannot take over a coredump");
		return;
	}
	_bpts->lift();
	if( error = core->reopen(t->procpath, t->stabpath) ){
		_bpts->lay();
		insert(ERRORKEY, error);
		return;
	}
	oldprocpath = procpath;
	oldstabpath = stabpath;
	oldcomment = comment;
	procpath = t->procpath;
	stabpath = t->stabpath;
	comment = t->comment;
	master->makeproc( oldprocpath, oldstabpath, oldcomment );
	t->isdead = 1;
	master->insert(t);
	master->insert(this);
	banner();
	if( _asm ) _asm->banner();
	if( _bpts ) _bpts->banner();
	if( memory ) memory->banner();
	if( globals ) globals->banner();
	if( sigmsk ){
		sigmsk->banner();
		sigmsk->updatecore();
	}
	if( srcdir ) srcdir->banner();
	core->symtab()->banner();
	pad->clear();
	_bpts->lay();
	docycle();
}

void HostProcess::imprint()
{
	int pid, ppid;

	sscanf(procpath, "%d", &pid);
	ppid = pi_getppid(pi_pidtoproc(pid));
	char *parentpath = sf("%05d", ppid);
	insert(ERRORKEY, "parent=%s", parentpath);
	Process *p = master->search(parentpath);
	if (!p) {
		insert(ERRORKEY, "parent (%d) not opened", ppid);
		return;
	}
	_bpts->liftparents(p->_bpts);
}

void HostProcess::userclose()
{
	if (sigmsk) {
		sigmsk->hostclose();
		delete sigmsk;
		sigmsk = 0;
	}
	Process::userclose();
}

void HostProcess::open(long ischild)
{
	Menu m, k, s;
	char *error;

	Process::openpad();
	if( core ) return;
	if (fixsymtab())
		return;
	core = newCore(master);
	if (!core) {
		insert(ERRORKEY, "Processor type not supported");
		return;
	}
	insert(ERRORKEY, "Checking process and symbol table...");
	if (error = core->open()) {
		delete core;
		core = 0;
		if (ischild)
			m.last("open child", (Action)&HostProcess::open, 1);
		else
			m.last("open process", (Action)&HostProcess::open, 0);
		pad->menu(m);
		insert(ERRORKEY, error);
		return;
	}
	insert(ERRORKEY, core->symtab()->warn());
	globals = new Globals(core);
	_asm = core->newAsm();
	m.last( "Source",  (Action)&Process::srcfiles    );
	m.last( "Globals",   (Action)&Process::openglobals );
	m.last( "Memory", (Action)&Process::openmemory  );
	m.last( "Assembler", (Action)&Process::openasm     );
	m.last( "User Types",(Action)&Process::opentypes   );
	if( core->online() ){
		m.last("Journal", (Action)&Process::openjournal);
		m.last("Signals", (Action)&HostProcess::opensigmask);
		m.last("Breakpoints", (Action)&HostProcess::openbpts);
		_bpts = new Bpts(core);
		_bpts->lay();
		if( ischild ) imprint();
		sigmsk = new SigMask(core);
	}
	if( core->online() ){
		s.last("run",		(Action)&Process::go);
		s.last("stop",		(Action)&Process::stop);
		s.last("current",	(Action)&Process::currentstmt);
		s.last("return",	(Action)&Process::pop);
		s.last("step into",	(Action)&Process::stepinto);
		s.last("step   1",	(Action)&Process::stmtstep, 1);
		s.last("step   5",	(Action)&Process::stmtstep, 5);
		s.last("step  25",	(Action)&Process::stmtstep, 25);
		s.last("step 100",	(Action)&Process::stmtstep, 100);
		s.last("step 500",	(Action)&Process::stmtstep, 500);
	} else
		s.first("stmt",		(Action)&Process::currentstmt);
	m.last(s.index("stmt"));
	if( core->online() ){
		k.last("kill?",		(Action)&HostProcess::destroy);
		m.last(k.index("kill"));
	}
	pad->menu(m.index("views"));
	pad->makecurrent();
	docycle();
	return;
}

void HostProcess::opensigmask()		{ if( sigmsk ) sigmsk->open(); }

void HostProcess::destroy()
{
	IF_LIVE( !core->online() ) return;
	insert(ERRORKEY, core->destroy());
	docycle();
}

void HostProcess::stop()
{
	IF_LIVE( !core->online() ) return;
#ifdef SIGSTOP
	if( !(sigmsk->mask&sigmsk->bit(SIGSTOP)) ) sigmsk->setsig(SIGSTOP);
#endif
	Process::stop();
}

Index HostProcess::carte()
{
	Menu m;
	if( !strcmp(procpath,"!") ){
		m.last( "hang & open proc", (Action)&HostProcess::hangopen );
		m.last( "hang & take over", (Action)&HostProcess::hangtakeover );
	} else if( alldigits(procpath) ) {
		m.last( "open process",  (Action)&HostProcess::open );
		m.last( "take over",    (Action)&HostProcess::takeover );
		m.last( "open child", (Action)&HostProcess::open, 1 );
	} else
		m.last( "open coredump",(Action)&HostProcess::open );
	return m.index();
}


void HostProcess::hang()
{
	int pid;
	char program[128];

	if (!(pid = pi_hang(stabpath)))
		insert(ERRORKEY, "Hang Failed");
	procpath = sf("%05d", pid);
	char *ssave = stabpath;
	if (pi_stabfdsupported())
		stabpath = 0;
	else {
		sscanf(stabpath, "%s", program);
		stabpath = sf("%s", program);
	}
	master->makeproc("!", ssave);
	master->insert(this);
}

void HostProcess::hangopen()
{
	hang();
	open(0);
}

void HostProcess::hangtakeover()
{
	hang();
	takeover();
}

Behavs HostCore::behavetype()		{ return behavs(); }
char *HostCore::eventname()		{ return signalname(state.code); }
int HostCore::atsyscall()		{ return pi_atsyscall(localp); }
char *HostCore::signalname(long sig)	{ return pi_signalname(sig); }
char *HostCore::resources()		{ return pi_proctime(localp); }
char *HostCore::run()			{ return pi_run(localp); }
char *HostCore::stop()			{ return pi_stop(localp); }
char *HostCore::destroy()		{ return pi_destroy(localp); }
long HostCore::regaddr()		{ return pi_regaddr(); }
long HostCore::scratchaddr()		{ return pi_scratchaddr(); }
int HostCore::nsig()			{ return pi_nsig(); }
long HostCore::signalmaskinit()		{ return pi_sigmaskinit(); }
int HostCore::exechangsupported()	{ return pi_exechangsupported(); }
char *HostCore::signalsend(long sig)	{ return pi_ssig(localp, sig); }
char *HostCore::signalclear()		{ return pi_csig(localp); }
char *HostCore::exechang(long e)	{ return pi_exechang(localp, e); }
char *HostCore::signalmask(long m)	{ return pi_sigmask(localp, m); }

char *HostCore::problem()
{
	static char buf[80];
	long sig;

	if (state.code & 0xFF) {
		sig = state.code & 0x7F;
		sprintf(buf, "died from signal %d(%s)", sig, signalname(sig));
	} else
		sprintf(buf, "exited with status %d",
			(state.code >> 8) & 0xFF);
	return buf;
}

char *HostCore::laybpt(Trap *t)
{
	if (bptsize && read(t->stmt->range.lo, t->saved, bptsize))
		return "laybpt: read failed";
	return pi_setbkpt(localp, t->stmt->range.lo);
}

Behavs HostCore::behavs()
{
	pi_getstate(localp, &state);
	switch (state.state) {
		case UNIX_HALTED: return HALTED;
		case UNIX_ACTIVE: return ACTIVE;
		case UNIX_BREAKED: return BREAKED;
		case UNIX_PENDING: return PENDING;
		case UNIX_ERRORED:
		default:
			return ERRORED;
	}
}

void HostCore::close()
{
	pi_close(localp);
	Core::close();
}

char *HostCore::open()
{
	char *s = stabpath();
	if (s) {
		stabfd = ::open(s, 0);
		if (stabfd < 0)
			return SysErr("symbol tables: ");
	} else if (!pi_stabfdsupported())
		return "symbol table file must be specified";
	char *p = procpath();
	if (alldigits(p)) {
		int procid;
		sscanf(p, "%d", &procid);
		_online = 1;
		if (!(localp = pi_open(procid)))
			return "can't open process";
	} else if (!(localp = pi_coreopen(p, s)))
		return "can't open core dump";
	if (!s)
		stabfd = pi_getsymtabfd(localp);
	stabfstat();
	newSymTab();
	_symtab->read();
	behavs();
	return 0;
}

char *HostCore::reopen(char *newprocpath, char *newstabpath)
{
	void *newp;
	char *err = 0;
	int compstabfd;

	if( !online() || (newprocpath && !alldigits(newprocpath)) )
		return "reopen core not implemented";
	int procid;
	sscanf(newprocpath, "%d", &procid);
	if (!(newp = pi_open(procid)))
		return "can't connect to new process";
	if (newstabpath || !pi_stabfdsupported())
		compstabfd = ::open(newstabpath, 0);
	else
		compstabfd = pi_getsymtabfd(newp);
	struct stat compstabstat;
	if( compstabfd < 0 || ::fstat(compstabfd, &compstabstat) )
		err = "symbol table error";
	else if( compstabstat.st_mtime != stabstat.st_mtime )
		err = "symbol tables differ (modified time)";
	else if( compstabstat.st_size != stabstat.st_size )
		err = "symbol tables differ (file size)";
	if (compstabfd >= 0)
		::close(compstabfd);
	if (err) {
		pi_close(newp);
		return err;
	}
	pi_close(localp);
	localp = newp;
	behavs();
	return 0;
}

char *HostCore::readwrite(long offset, char *buf, int r, int w)
{
	return pi_readwrite(localp, buf, offset, r, w);
}

const int	STEPWAIT = 15;
char *HostCore::dostep(long lo, long hi, int sstep)
{
	char *error;
	long fp0, pcs, time0;

	time0 = ::time((long*)0);
	for(fp0 = fp(), pcs = pc();;){
		if( hi && atjsr(pcs) ) {
			error = stepoverjsr();
			goto next;
		}
		if (sstep)
			error = pi_step(localp);
		else {
			error = run();
			if (!error) {
				error = pi_waitstop(localp);
				if (error)
					stop();
			}
		}
		if( !error && behavetype() != BREAKED)
			return "step error";
next:
		if( error ) return error;
		if( !hi || (pcs = pc()) < lo || pcs >= hi
		 || ((stackdir == GROWDOWN ? (fp() > fp0) : (fp() < fp0))
		     && !atreturn(pcs)) )
			return 0;
		if( ::time((long*)0) > time0+STEPWAIT )
			return sf("single step timeout (%d secs)", STEPWAIT);
	}
}
